/*
 * Decompiled with CFR 0.152.
 */
package jade.content.abs;

import jade.content.ContentElement;
import jade.content.ContentElementList;
import jade.content.OntoACLMessage;
import jade.content.OntoAID;
import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ACLMessage;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.util.Iterator;

public class AbsHelper {
    public static AbsAggregate externaliseList(List obj, Ontology onto, String AggregateType) throws OntologyException {
        AbsAggregate ret = new AbsAggregate(AggregateType);
        try {
            int i = 0;
            while (i < obj.size()) {
                ret.add((AbsTerm)onto.fromObject(obj.get(i)));
                ++i;
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non term object in aggregate");
        }
        return ret;
    }

    public static AbsAggregate externaliseIterator(Iterator obj, Ontology onto, String AggregateType) throws OntologyException {
        AbsAggregate ret = new AbsAggregate(AggregateType);
        try {
            while (obj.hasNext()) {
                ret.add((AbsTerm)onto.fromObject(obj.next()));
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non term object in aggregate");
        }
        return ret;
    }

    public static AbsConcept externaliseAID(AID obj) {
        AbsConcept aid = new AbsConcept("agent-identifier");
        aid.set("name", obj.getName());
        jade.util.leap.Iterator i = obj.getAllAddresses();
        if (i.hasNext()) {
            AbsAggregate addresses = new AbsAggregate("sequence");
            while (i.hasNext()) {
                String addr = (String)i.next();
                addresses.add(AbsPrimitive.wrap(addr));
            }
            aid.set("addresses", addresses);
        }
        if ((i = obj.getAllResolvers()).hasNext()) {
            AbsAggregate resolvers = new AbsAggregate("sequence");
            while (i.hasNext()) {
                AID res = (AID)i.next();
                resolvers.add(AbsHelper.externaliseAID(res));
            }
            aid.set("resolvers", resolvers);
        }
        return aid;
    }

    public static AbsContentElementList externaliseContentElementList(ContentElementList obj, Ontology onto) throws OntologyException {
        AbsContentElementList ret = new AbsContentElementList();
        try {
            int i = 0;
            while (i < obj.size()) {
                ret.add((AbsContentElement)onto.fromObject(obj.get(i)));
                ++i;
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non content element object in content element list");
        }
        return ret;
    }

    public static AbsAgentAction externaliseACLMessage(ACLMessage obj, Ontology onto) throws OntologyException {
        try {
            AbsAgentAction absMsg = new AbsAgentAction(ACLMessage.getPerformative(obj.getPerformative()));
            absMsg.set("sender", (AbsTerm)onto.fromObject(obj.getSender()));
            AbsAggregate recvs = new AbsAggregate("sequence");
            jade.util.leap.Iterator it = obj.getAllReceiver();
            while (it.hasNext()) {
                recvs.add((AbsTerm)onto.fromObject(it.next()));
            }
            if (recvs.size() > 0) {
                absMsg.set("receivers", recvs);
            }
            AbsAggregate repls = new AbsAggregate("sequence");
            it = obj.getAllReplyTo();
            while (it.hasNext()) {
                repls.add((AbsTerm)onto.fromObject(it.next()));
            }
            if (repls.size() > 0) {
                absMsg.set("reply-to", repls);
            }
            absMsg.set("language", obj.getLanguage());
            absMsg.set("ontology", obj.getOntology());
            absMsg.set("protocol", obj.getProtocol());
            absMsg.set("in-reply-to", obj.getInReplyTo());
            absMsg.set("reply-with", obj.getReplyWith());
            absMsg.set("conversation-id", obj.getConversationId());
            absMsg.set("reply-by", obj.getReplyByDate());
            if (obj.hasByteSequenceContent()) {
                absMsg.set("bs-content", obj.getByteSequenceContent());
            } else {
                absMsg.set("content", obj.getContent());
            }
            absMsg.set("encoding", obj.getEncoding());
            return absMsg;
        }
        catch (Exception e) {
            throw new OntologyException("Error externalising ACLMessage", e);
        }
    }

    public static List internaliseList(AbsAggregate aggregate, Ontology onto) throws OntologyException {
        ArrayList ret = new ArrayList();
        int i = 0;
        while (i < aggregate.size()) {
            Object element = onto.toObject(aggregate.get(i));
            Ontology.checkIsTerm(element);
            ret.add(element);
            ++i;
        }
        return ret;
    }

    public static OntoAID internaliseAID(AbsConcept aid) throws OntologyException {
        OntoAID ret = new OntoAID();
        try {
            AbsAggregate resolvers;
            ret.setName(aid.getString("name"));
            AbsAggregate addresses = (AbsAggregate)aid.getAbsObject("addresses");
            if (addresses != null) {
                int i = 0;
                while (i < addresses.size()) {
                    String addr = ((AbsPrimitive)addresses.get(i)).getString();
                    ret.addAddresses(addr);
                    ++i;
                }
            }
            if ((resolvers = (AbsAggregate)aid.getAbsObject("resolvers")) != null) {
                int i = 0;
                while (i < resolvers.size()) {
                    OntoAID res = AbsHelper.internaliseAID((AbsConcept)resolvers.get(i));
                    ret.addResolvers(res);
                    ++i;
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new OntologyException(aid + " is not a valid AID");
        }
    }

    public static ContentElementList internaliseContentElementList(AbsContentElementList l, Ontology onto) throws OntologyException {
        ContentElementList ret = new ContentElementList();
        try {
            int i = 0;
            while (i < l.size()) {
                ContentElement element = (ContentElement)onto.toObject(l.get(i));
                ret.add(element);
                ++i;
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non content element object in content element list");
        }
        return ret;
    }

    public static OntoACLMessage internaliseACLMessage(AbsAgentAction absMsg, Ontology onto) throws OntologyException {
        OntoACLMessage ret = new OntoACLMessage(ACLMessage.getInteger(absMsg.getTypeName()));
        try {
            jade.util.leap.Iterator it;
            ret.setSender((AID)onto.toObject(absMsg.getAbsObject("sender")));
            ret.clearAllReceiver();
            List l = (List)onto.toObject(absMsg.getAbsObject("receivers"));
            if (l != null) {
                it = l.iterator();
                while (it.hasNext()) {
                    ret.addReceiver((AID)it.next());
                }
            }
            ret.clearAllReplyTo();
            l = (List)onto.toObject(absMsg.getAbsObject("reply-to"));
            if (l != null) {
                it = l.iterator();
                while (it.hasNext()) {
                    ret.addReplyTo((AID)it.next());
                }
            }
            ret.setLanguage(absMsg.getString("language"));
            ret.setOntology(absMsg.getString("ontology"));
            ret.setProtocol(absMsg.getString("protocol"));
            ret.setInReplyTo(absMsg.getString("in-reply-to"));
            ret.setReplyWith(absMsg.getString("reply-with"));
            ret.setConversationId(absMsg.getString("conversation-id"));
            ret.setReplyByDate(absMsg.getDate("reply-by"));
            String c = absMsg.getString("content");
            if (c != null) {
                ret.setContent(c);
            } else {
                byte[] bsc = absMsg.getByteSequence("bs-content");
                if (bsc != null) {
                    ret.setByteSequenceContent(bsc);
                }
            }
            ret.setEncoding(absMsg.getString("encoding"));
            return ret;
        }
        catch (Exception e) {
            throw new OntologyException("Error internalising OntoACLMessage", e);
        }
    }

    public static void setAttribute(AbsObject abs, String attrName, AbsObject attrValue) throws OntologyException {
        if (abs.getAbsType() == 3) {
            if (attrValue instanceof AbsTerm) {
                ((AbsAgentAction)abs).set(attrName, (AbsTerm)attrValue);
                return;
            }
            if (attrValue instanceof AbsPredicate) {
                ((AbsAgentAction)abs).set(attrName, (AbsPredicate)attrValue);
                return;
            }
        }
        if (abs.getAbsType() == 2) {
            if (attrValue instanceof AbsTerm) {
                ((AbsConcept)abs).set(attrName, (AbsTerm)attrValue);
                return;
            }
        } else {
            if (abs.getAbsType() == 1) {
                ((AbsPredicate)abs).set(attrName, attrValue);
                return;
            }
            if (abs.getAbsType() == 6) {
                if (attrValue instanceof AbsVariable && CaseInsensitiveString.equalsIgnoreCase(attrName, "Variable")) {
                    ((AbsIRE)abs).setVariable((AbsVariable)attrValue);
                    return;
                }
                if (attrValue instanceof AbsPredicate && CaseInsensitiveString.equalsIgnoreCase(attrName, "Proposition")) {
                    ((AbsIRE)abs).setProposition((AbsPredicate)attrValue);
                    return;
                }
            } else if (abs.getAbsType() == 7) {
                if (attrValue instanceof AbsPrimitive && CaseInsensitiveString.equalsIgnoreCase(attrName, "Name")) {
                    ((AbsVariable)abs).setName(((AbsPrimitive)attrValue).getString());
                    return;
                }
                if (attrValue instanceof AbsPrimitive && CaseInsensitiveString.equalsIgnoreCase(attrName, "ValueType")) {
                    ((AbsVariable)abs).setType(((AbsPrimitive)attrValue).getString());
                    return;
                }
            }
        }
        throw new OntologyException("Type incompatibility: value of attribute " + attrName + " of " + abs + " is " + attrValue);
    }
}

